/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.util.LineLoggingBuffer;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LoggingInputStream
extends FilterInputStream {
    protected final LineLoggingBuffer loggingBuffer;

    public LoggingInputStream(InputStream is, String prefix) {
        super(is);
        this.loggingBuffer = new LineLoggingBuffer(prefix);
    }

    @Override
    public synchronized int read() throws IOException {
        int b = super.read();
        this.loggingBuffer.append(b);
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        for (int i2 = off; i2 < off + bytesRead; ++i2) {
            this.loggingBuffer.append(b[i2]);
        }
        return bytesRead;
    }

    @Override
    public synchronized void close() throws IOException {
        this.loggingBuffer.logLine();
        super.close();
    }
}

