/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class EntryListIntegerIntegerCodec {
    private static final int ENTRY_SIZE_IN_BYTES = 8;

    private EntryListIntegerIntegerCodec() {
    }

    public static void encode(ClientMessage clientMessage, Collection<Map.Entry<Integer, Integer>> collection) {
        int itemCount = collection.size();
        ClientMessage.Frame frame = new ClientMessage.Frame(new byte[itemCount * 8]);
        Iterator<Map.Entry<Integer, Integer>> iterator = collection.iterator();
        for (int i2 = 0; i2 < itemCount; ++i2) {
            Map.Entry<Integer, Integer> entry = iterator.next();
            FixedSizeTypesCodec.encodeInt(frame.content, i2 * 8, entry.getKey());
            FixedSizeTypesCodec.encodeInt(frame.content, i2 * 8 + 4, entry.getValue());
        }
        clientMessage.add(frame);
    }

    public static List<Map.Entry<Integer, Integer>> decode(ClientMessage.ForwardFrameIterator iterator) {
        ClientMessage.Frame frame = iterator.next();
        int itemCount = frame.content.length / 8;
        ArrayList<Map.Entry<Integer, Integer>> result = new ArrayList<Map.Entry<Integer, Integer>>(itemCount);
        for (int i2 = 0; i2 < itemCount; ++i2) {
            int key = FixedSizeTypesCodec.decodeInt(frame.content, i2 * 8);
            int value = FixedSizeTypesCodec.decodeInt(frame.content, i2 * 8 + 4);
            result.add(new AbstractMap.SimpleEntry<Integer, Integer>(key, value));
        }
        return result;
    }
}

