/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.AlgorithmParameter;
import net.messagevortex.asn1.AsymmetricKey;
import net.messagevortex.asn1.encryption.Algorithm;
import net.messagevortex.asn1.encryption.Parameter;
import net.messagevortex.asn1.encryption.SecurityLevel;

public class AsymmetricKeyCache
implements Serializable {
    public static final long serialVersionUID = 12312123L;
    public static final SecureRandom esr = new SecureRandom();
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private transient Map<AlgorithmParameter, CacheElement> cache = new TreeMap<AlgorithmParameter, CacheElement>();

    public void store(String filename) throws IOException {
        if (filename == null || "".equals(filename)) {
            filename = "AsymmetricKey.cache";
        }
        Path p = Paths.get(filename, new String[0]);
        try (ObjectOutputStream os = new ObjectOutputStream(Files.newOutputStream(p, new OpenOption[0]));){
            os.writeObject(this);
        }
        LOGGER.log(Level.INFO, "stored cache to file \"" + filename + "\"");
        this.showStats();
    }

    public void load(String filename) throws IOException {
        Path p = Paths.get(filename, new String[0]);
        try (ObjectInputStream is = new ObjectInputStream(Files.newInputStream(p, new OpenOption[0]));){
            this.load(is, false);
        }
        LOGGER.log(Level.INFO, "loaded cache from file \"" + filename + "\"");
        this.showStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(ObjectInputStream f, boolean merge) throws IOException {
        Map<AlgorithmParameter, CacheElement> map = this.cache;
        synchronized (map) {
            if (!merge) {
                this.cache.clear();
            }
            try {
                AsymmetricKeyCache tc = (AsymmetricKeyCache)f.readObject();
                if (!merge) {
                    this.cache.clear();
                    this.cache.putAll(tc.cache);
                } else {
                    for (Map.Entry<AlgorithmParameter, CacheElement> ce : tc.cache.entrySet()) {
                        CacheElement t = this.cache.get(ce.getKey());
                        if (t == null) {
                            this.cache.put(ce.getKey(), ce.getValue());
                            continue;
                        }
                        t.merge(ce.getValue());
                    }
                }
            }
            catch (ClassNotFoundException | NullPointerException cnfe) {
                LOGGER.log(Level.WARNING, "got unexpected exception when deserializing (old cache)... initializing with standard values", cnfe);
                this.initCache();
            }
        }
    }

    private void initCache() {
        this.cache.clear();
        this.cache.put(Algorithm.RSA.getParameters(SecurityLevel.LOW), new CacheElement(40000));
        this.cache.put(Algorithm.RSA.getParameters(SecurityLevel.MEDIUM), new CacheElement(4000));
        this.cache.put(Algorithm.RSA.getParameters(SecurityLevel.HIGH), new CacheElement(400));
        this.cache.put(Algorithm.RSA.getParameters(SecurityLevel.QUANTUM), new CacheElement(40));
        this.cache.put(Algorithm.EC.getParameters(SecurityLevel.LOW), new CacheElement(40000));
        this.cache.put(Algorithm.EC.getParameters(SecurityLevel.MEDIUM), new CacheElement(4000));
        this.cache.put(Algorithm.EC.getParameters(SecurityLevel.HIGH), new CacheElement(400));
        this.cache.put(Algorithm.EC.getParameters(SecurityLevel.QUANTUM), new CacheElement(40));
    }

    public void merge(String filename) throws IOException {
        Path p = Paths.get(filename, new String[0]);
        try (ObjectInputStream is = new ObjectInputStream(Files.newInputStream(p, new OpenOption[0]));){
            this.load(is, true);
        }
        catch (ClassCastException cce) {
            throw new IOException("Error deserializing file \"" + filename + "\"", cce);
        }
    }

    public void setCalcTime(AlgorithmParameter ap, long millis) {
        CacheElement ce = this.cache.get(ap);
        if (ce != null) {
            ce.setCalcTime(millis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AlgorithmParameter getCacheElementByIndex(int index) {
        Map<AlgorithmParameter, CacheElement> map = this.cache;
        synchronized (map) {
            int i = 0;
            for (Map.Entry<AlgorithmParameter, CacheElement> e : this.cache.entrySet()) {
                if (++i != index) continue;
                return e.getKey();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsymmetricKey pull(AlgorithmParameter parameter) {
        Map<AlgorithmParameter, CacheElement> map = this.cache;
        synchronized (map) {
            CacheElement ce = this.cache.get(parameter);
            if (ce == null) {
                ce = new CacheElement();
                this.cache.put(parameter, ce);
            }
            return ce.pull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsymmetricKey peek(AlgorithmParameter parameter) {
        Map<AlgorithmParameter, CacheElement> map = this.cache;
        synchronized (map) {
            CacheElement ce = this.cache.get(parameter);
            if (ce == null) {
                ce = new CacheElement();
                this.cache.put(parameter, ce);
            }
            return ce.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(AsymmetricKey key) {
        AlgorithmParameter ap = key.getAlgorithmParameter();
        Map<AlgorithmParameter, CacheElement> map = this.cache;
        synchronized (map) {
            CacheElement ce = this.cache.get(ap);
            if (ce == null) {
                ce = new CacheElement();
                this.cache.put(ap, ce);
            }
            ce.push(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCacheIncrease(AlgorithmParameter parameter) {
        Map<AlgorithmParameter, CacheElement> map = this.cache;
        synchronized (map) {
            CacheElement ce = this.cache.get(parameter);
            if (ce == null) {
                ce = new CacheElement();
                this.cache.put(parameter, ce);
            }
            ce.requestCacheIncrease();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlgorithmParameter getSpeculativeParameter() {
        long e;
        long l = 0L;
        TreeMap<Long, AlgorithmParameter> hm = new TreeMap<Long, AlgorithmParameter>();
        Map<AlgorithmParameter, CacheElement> map = this.cache;
        synchronized (map) {
            for (Map.Entry<AlgorithmParameter, CacheElement> me : this.cache.entrySet()) {
                long l2 = (long)me.getValue().getCacheFillTime();
                l += l2;
                if (l2 <= 0L) continue;
                hm.put(l, me.getKey());
            }
        }
        if (l == 0L || hm.size() == 0) {
            return null;
        }
        SecureRandom secureRandom = esr;
        synchronized (secureRandom) {
            e = Math.abs(esr.nextLong() % (l + 1L));
        }
        for (Map.Entry entry : hm.entrySet()) {
            if ((Long)entry.getKey() < e) continue;
            return (AlgorithmParameter)entry.getValue();
        }
        return null;
    }

    public double getLowestCacheSize() {
        double lowest = 0.0;
        for (Map.Entry<AlgorithmParameter, CacheElement> e : this.cache.entrySet()) {
            lowest = Math.min(lowest, (double)e.getValue().size() / (double)e.getValue().getMaxSize());
        }
        return lowest;
    }

    public double getCacheFillGrade() {
        double maxSize = 0.0;
        double currSize = 0.0;
        for (Map.Entry<AlgorithmParameter, CacheElement> e : this.cache.entrySet()) {
            maxSize += (double)e.getValue().getMaxSize();
            currSize += (double)Math.min(e.getValue().size(), e.getValue().getMaxSize());
        }
        if (maxSize == 0.0) {
            return 1.0;
        }
        double fg = currSize / maxSize;
        LOGGER.log(Level.FINE, "Cache fill grade is " + fg);
        return fg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<AlgorithmParameter, CacheElement> map = this.cache;
        synchronized (map) {
            for (CacheElement ce : this.cache.values()) {
                ce.clearCache();
            }
        }
    }

    public boolean isEmpty() {
        double size = 0.0;
        for (Map.Entry<AlgorithmParameter, CacheElement> e : this.cache.entrySet()) {
            size += (double)e.getValue().size() / (double)e.getValue().getMaxSize();
        }
        return (int)size == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        Map<AlgorithmParameter, CacheElement> map = this.cache;
        synchronized (map) {
            out.writeInt(this.cache.size());
            for (Map.Entry<AlgorithmParameter, CacheElement> me : this.cache.entrySet()) {
                out.writeObject(me.getKey());
                out.writeObject(me.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        try {
            int i = in.readInt();
            if (this.cache == null) {
                this.cache = new TreeMap<AlgorithmParameter, CacheElement>();
            }
            this.cache.clear();
            for (int j = 0; j < i; ++j) {
                this.cache.put((AlgorithmParameter)in.readObject(), (CacheElement)in.readObject());
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Exception while reading cache file", cnfe);
        }
    }

    private static String percentBar(double percent, int size) {
        StringBuilder sb = new StringBuilder();
        sb.append('|');
        int i = 1;
        while ((double)i < Math.min((double)size, percent * (double)size)) {
            sb.append('#');
            ++i;
        }
        while (sb.length() < size) {
            sb.append('.');
        }
        sb.append('|');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheSize(int index, int value) throws IOException {
        Map<AlgorithmParameter, CacheElement> map = this.cache;
        synchronized (map) {
            AlgorithmParameter ap = this.getCacheElementByIndex(index);
            if (ap == null) {
                throw new IOException("cache element " + index + " not found");
            }
            CacheElement ce = this.cache.get(ap);
            ce.setMaxSize(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheElement(int index) throws IOException {
        Map<AlgorithmParameter, CacheElement> map = this.cache;
        synchronized (map) {
            AlgorithmParameter ap = this.getCacheElementByIndex(index);
            if (ap == null) {
                throw new IOException("cache element " + index + " not found");
            }
            this.cache.remove(ap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showStats() {
        String sepLine = "-----------------------------------------------------------";
        Map<AlgorithmParameter, CacheElement> map = this.cache;
        synchronized (map) {
            LOGGER.log(Level.INFO, "-----------------------------------------------------------");
            LOGGER.log(Level.INFO, "| cache stats ");
            LOGGER.log(Level.INFO, "-----------------------------------------------------------");
            int sum = 0;
            int tot = 0;
            int i = 0;
            for (Map.Entry<AlgorithmParameter, CacheElement> e : this.cache.entrySet()) {
                CacheElement ce = e.getValue();
                long s = ce.size();
                long ms = ce.getMaxSize();
                LOGGER.log(Level.INFO, "|" + String.format("%2s", ++i) + ") " + String.format("%5s", s) + "/" + String.format("%5s", ms) + " " + AsymmetricKeyCache.percentBar((double)s / (double)ms, 20) + " " + String.valueOf(e.getKey()));
                sum = (int)((long)sum + s);
                tot = (int)((long)tot + ms);
            }
            LOGGER.log(Level.INFO, "-----------------------------------------------------------");
            LOGGER.log(Level.INFO, "| Total: " + sum + "/" + tot);
            LOGGER.log(Level.INFO, "-----------------------------------------------------------");
        }
    }

    private static class CacheElement
    implements Serializable {
        public static final long serialVersionUID = 100000000080L;
        private static final int MAX_NUMBER_OF_CALC_TIMES = 100;
        private static final int MAX_CACHE_SIZE = 40000;
        private int maxSize = 1;
        private long averageCalcTime = 100L;
        private int numberOfCalcTimes = 0;
        private Queue<AsymmetricKey> elementCache = new ArrayDeque<AsymmetricKey>();

        public CacheElement() {
            this(1);
            this.elementCache = new ArrayDeque<AsymmetricKey>();
        }

        public CacheElement(int initialSize) {
            this.maxSize = initialSize;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public int setMaxSize(int size) {
            int ret = this.maxSize;
            this.maxSize = size;
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AsymmetricKey pull() {
            Queue<AsymmetricKey> queue = this.elementCache;
            synchronized (queue) {
                if (this.elementCache.size() > 0) {
                    return this.elementCache.poll();
                }
                ++this.maxSize;
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AsymmetricKey peek() {
            Queue<AsymmetricKey> queue = this.elementCache;
            synchronized (queue) {
                if (this.elementCache.size() > 0) {
                    return this.elementCache.peek();
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void push(AsymmetricKey key) {
            Queue<AsymmetricKey> queue = this.elementCache;
            synchronized (queue) {
                AlgorithmParameter p = key.getAlgorithmParameter();
                assert (key.getAlgorithm() != Algorithm.EC || p.get(Parameter.CURVETYPE).indexOf(p.get(Parameter.BLOCKSIZE)) > 0) : "found mismatch in curve type vs blocksize (" + p.get(Parameter.BLOCKSIZE) + "/" + p.get(Parameter.CURVETYPE) + ")";
                assert (key.getAlgorithm() != Algorithm.RSA || p.get(Parameter.KEYSIZE).equals(p.get(Parameter.BLOCKSIZE))) : "found mismatch in RSA keysize vs blocksize (ks:" + p.get(Parameter.KEYSIZE) + "/bs:" + p.get(Parameter.BLOCKSIZE) + ")";
                this.elementCache.add(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCalcTime(long millis) {
            Queue<AsymmetricKey> queue = this.elementCache;
            synchronized (queue) {
                this.averageCalcTime = (this.averageCalcTime * (long)this.numberOfCalcTimes + millis) / (long)(this.numberOfCalcTimes + 1);
                this.numberOfCalcTimes = Math.min(this.numberOfCalcTimes, 100);
            }
        }

        public double getAverageCalcTime() {
            return this.averageCalcTime;
        }

        public double getCacheFillTime() {
            double avg = this.getAverageCalcTime();
            if (avg <= 0.0) {
                avg = 10.0;
            }
            return (double)Math.max(0, this.maxSize - this.elementCache.size()) * avg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Queue<AsymmetricKey> queue = this.elementCache;
            synchronized (queue) {
                return this.elementCache.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearCache() {
            Queue<AsymmetricKey> queue = this.elementCache;
            synchronized (queue) {
                this.elementCache.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void merge(CacheElement element) {
            Queue<AsymmetricKey> queue = this.elementCache;
            synchronized (queue) {
                for (AsymmetricKey e : element.elementCache) {
                    this.push(e);
                }
                this.maxSize = Math.max(this.maxSize, element.maxSize);
                if (this.numberOfCalcTimes + element.numberOfCalcTimes > 0) {
                    this.averageCalcTime = (this.averageCalcTime * (long)this.numberOfCalcTimes + element.averageCalcTime * (long)element.numberOfCalcTimes) / (long)(this.numberOfCalcTimes + element.numberOfCalcTimes);
                }
                this.numberOfCalcTimes = Math.max(this.numberOfCalcTimes + element.numberOfCalcTimes, 100);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream out) throws IOException {
            Queue<AsymmetricKey> queue = this.elementCache;
            synchronized (queue) {
                out.writeObject(this.maxSize);
                out.writeObject(this.averageCalcTime);
                out.writeObject(this.numberOfCalcTimes);
                out.writeObject(this.elementCache.size());
                for (AsymmetricKey ak : this.elementCache) {
                    out.writeObject(ak);
                }
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.maxSize = (Integer)in.readObject();
            this.averageCalcTime = (Long)in.readObject();
            this.numberOfCalcTimes = (Integer)in.readObject();
            int i = (Integer)in.readObject();
            if (this.elementCache == null) {
                this.elementCache = new ArrayDeque<AsymmetricKey>();
            }
            this.elementCache.clear();
            for (int j = 0; j < i; ++j) {
                this.push((AsymmetricKey)in.readObject());
            }
        }

        public void requestCacheIncrease() {
            this.maxSize = Math.min(40000, Math.max((int)((double)this.maxSize * 1.1), this.maxSize + 1));
        }
    }
}

